--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.3
-- Dumped by pg_dump version 9.5.6

-- Started on 2017-03-15 11:45:07 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

SET search_path = oereb_ortsplanung, pg_catalog;

SET default_with_oids = false;

--
-- TOC entry 3149 (class 1259 OID 35879)
-- Name: awb; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE awb (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    name character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    bemerkungen character varying(255),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying DEFAULT 0 NOT NULL,
    id_freigabebeschluss character varying,
    id_rechtsmittelinstanz character varying,
    id_genehmigung_zonenplan character varying,
    id_inkraftsetzung character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22451 (class 0 OID 0)
-- Dependencies: 3149
-- Name: TABLE awb; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE awb IS '@iliname ORTSPLANUNG.Nutz_Plan.AWB';


--
-- TOC entry 3150 (class 1259 OID 35886)
-- Name: awb_info; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE awb_info (
    t_ili_tid character varying(200),
    kanton integer,
    kanton_txt character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    datenlieferant character varying(100) NOT NULL,
    erfassungsstand integer,
    erfassungsstand_txt character varying(255) NOT NULL,
    nachfuehrungsstand date NOT NULL,
    aufhebung_dyn_waldbegriff integer,
    aufhebung_dyn_waldbegriff_txt character varying(255) NOT NULL,
    bemerkung character varying(255),
    oid character varying(30),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22452 (class 0 OID 0)
-- Dependencies: 3150
-- Name: TABLE awb_info; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE awb_info IS '@iliname ORTSPLANUNG.Nutz_Plan.AWB_Info';


--
-- TOC entry 3151 (class 1259 OID 35892)
-- Name: awb_info_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE awb_info_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22453 (class 0 OID 0)
-- Dependencies: 3151
-- Name: awb_info_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE awb_info_prid_seq OWNED BY awb_info.prid;


--
-- TOC entry 3154 (class 1259 OID 35902)
-- Name: awb_linie; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE awb_linie (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrie public.geometry(CompoundCurve,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_awb character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22454 (class 0 OID 0)
-- Dependencies: 3154
-- Name: TABLE awb_linie; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE awb_linie IS '@iliname ORTSPLANUNG.Nutz_Plan.AWB_Linie';


--
-- TOC entry 3155 (class 1259 OID 35908)
-- Name: awb_linie_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE awb_linie_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22455 (class 0 OID 0)
-- Dependencies: 3155
-- Name: awb_linie_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE awb_linie_prid_seq OWNED BY awb_linie.prid;


--
-- TOC entry 3158 (class 1259 OID 35918)
-- Name: awb_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE awb_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22456 (class 0 OID 0)
-- Dependencies: 3158
-- Name: awb_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE awb_prid_seq OWNED BY awb.prid;


--
-- TOC entry 3159 (class 1259 OID 35920)
-- Name: awb_punkte; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE awb_punkte (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    punktname character varying(20) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(Point,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_awb_linie character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22457 (class 0 OID 0)
-- Dependencies: 3159
-- Name: TABLE awb_punkte; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE awb_punkte IS '@iliname ORTSPLANUNG.Nutz_Plan.AWB_Punkte';


--
-- TOC entry 3160 (class 1259 OID 35926)
-- Name: awb_punkte_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE awb_punkte_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22458 (class 0 OID 0)
-- Dependencies: 3160
-- Name: awb_punkte_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE awb_punkte_prid_seq OWNED BY awb_punkte.prid;


--
-- TOC entry 3165 (class 1259 OID 35944)
-- Name: beschluesse; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE beschluesse (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    behoerde integer,
    behoerde_txt character varying(255) NOT NULL,
    ort_der_behoerde character varying(100),
    nummer character varying(50),
    datum_beschluss date,
    datum_inkraftsetzung date,
    bezeichnung character varying(100),
    datum_von date,
    datum_bis date,
    id_oereb_url character varying(255),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22459 (class 0 OID 0)
-- Dependencies: 3165
-- Name: TABLE beschluesse; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE beschluesse IS '@iliname ORTSPLANUNG.Nutz_Plan.Beschluesse';


--
-- TOC entry 3166 (class 1259 OID 35950)
-- Name: beschluesse_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE beschluesse_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22460 (class 0 OID 0)
-- Dependencies: 3166
-- Name: beschluesse_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE beschluesse_prid_seq OWNED BY beschluesse.prid;


--
-- TOC entry 3169 (class 1259 OID 35960)
-- Name: blp; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE blp (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    name character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    gueltig_bis date,
    gueltig_von date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22461 (class 0 OID 0)
-- Dependencies: 3169
-- Name: TABLE blp; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE blp IS '@iliname ORTSPLANUNG.Nutz_Plan.BLP';


--
-- TOC entry 3170 (class 1259 OID 35966)
-- Name: blp_flaechen; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE blp_flaechen (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_blp character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22462 (class 0 OID 0)
-- Dependencies: 3170
-- Name: TABLE blp_flaechen; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE blp_flaechen IS '@iliname ORTSPLANUNG.Nutz_Plan.BLP_Flaechen';


--
-- TOC entry 3171 (class 1259 OID 35972)
-- Name: blp_flaechen_beschluesse; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE blp_flaechen_beschluesse (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_blp_flaechen character varying,
    id_genehmigung character varying,
    id_inkraftsetzung character varying,
    id_erlass character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22463 (class 0 OID 0)
-- Dependencies: 3171
-- Name: TABLE blp_flaechen_beschluesse; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE blp_flaechen_beschluesse IS '@iliname ORTSPLANUNG.Nutz_Plan.BLP_Flaechen_Beschluesse';


--
-- TOC entry 3172 (class 1259 OID 35978)
-- Name: blp_flaechen_beschluesse_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE blp_flaechen_beschluesse_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22464 (class 0 OID 0)
-- Dependencies: 3172
-- Name: blp_flaechen_beschluesse_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE blp_flaechen_beschluesse_prid_seq OWNED BY blp_flaechen_beschluesse.prid;


--
-- TOC entry 3175 (class 1259 OID 35988)
-- Name: blp_flaechen_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE blp_flaechen_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22465 (class 0 OID 0)
-- Dependencies: 3175
-- Name: blp_flaechen_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE blp_flaechen_prid_seq OWNED BY blp_flaechen.prid;


--
-- TOC entry 3178 (class 1259 OID 35998)
-- Name: blp_linie; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE blp_linie (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    typ integer,
    typ_txt character varying(255) NOT NULL,
    bezeichnung character varying(255),
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    geometrie public.geometry(CompoundCurve,2056),
    anfangspunkt character varying(80),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_blp character varying,
    id_genehmigung character varying,
    id_inkraftsetzung character varying,
    id_erlass character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22466 (class 0 OID 0)
-- Dependencies: 3178
-- Name: TABLE blp_linie; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE blp_linie IS '@iliname ORTSPLANUNG.Nutz_Plan.BLP_Linie';


--
-- TOC entry 3179 (class 1259 OID 36004)
-- Name: blp_linie_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE blp_linie_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22467 (class 0 OID 0)
-- Dependencies: 3179
-- Name: blp_linie_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE blp_linie_prid_seq OWNED BY blp_linie.prid;


--
-- TOC entry 3182 (class 1259 OID 36014)
-- Name: blp_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE blp_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22468 (class 0 OID 0)
-- Dependencies: 3182
-- Name: blp_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE blp_prid_seq OWNED BY blp.prid;


--
-- TOC entry 3185 (class 1259 OID 36024)
-- Name: gemeinde_tg; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE gemeinde_tg (
    t_id integer NOT NULL,
    t_ili_tid character varying(200),
    gemeinde_id character varying(5) NOT NULL,
    nummer integer NOT NULL,
    name character varying(50) NOT NULL,
    typ integer NOT NULL,
    typ_txt character varying(255) NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22469 (class 0 OID 0)
-- Dependencies: 3185
-- Name: TABLE gemeinde_tg; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE gemeinde_tg IS '@iliname GEMEINDEKATALOG_TG01.Gemeindekat_TG.Gemeinde_TG';


--
-- TOC entry 3186 (class 1259 OID 36030)
-- Name: gemeinde_tg_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE gemeinde_tg_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22470 (class 0 OID 0)
-- Dependencies: 3186
-- Name: gemeinde_tg_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE gemeinde_tg_prid_seq OWNED BY gemeinde_tg.prid;


--
-- TOC entry 3187 (class 1259 OID 36032)
-- Name: gp; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE gp (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    name character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    typ integer,
    typ_txt character varying(255) NOT NULL,
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22471 (class 0 OID 0)
-- Dependencies: 3187
-- Name: TABLE gp; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE gp IS '@iliname ORTSPLANUNG.Nutz_Plan.GP';


--
-- TOC entry 3188 (class 1259 OID 36038)
-- Name: gp_beschluesse; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE gp_beschluesse (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_gp character varying,
    id_genehmigung character varying,
    id_inkraftsetzung character varying,
    id_erlass character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22472 (class 0 OID 0)
-- Dependencies: 3188
-- Name: TABLE gp_beschluesse; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE gp_beschluesse IS '@iliname ORTSPLANUNG.Nutz_Plan.GP_Beschluesse';


--
-- TOC entry 3189 (class 1259 OID 36044)
-- Name: gp_beschluesse_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE gp_beschluesse_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22473 (class 0 OID 0)
-- Dependencies: 3189
-- Name: gp_beschluesse_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE gp_beschluesse_prid_seq OWNED BY gp_beschluesse.prid;


--
-- TOC entry 3192 (class 1259 OID 36054)
-- Name: gp_flaechen; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE gp_flaechen (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_gp character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22474 (class 0 OID 0)
-- Dependencies: 3192
-- Name: TABLE gp_flaechen; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE gp_flaechen IS '@iliname ORTSPLANUNG.Nutz_Plan.GP_Flaechen';


--
-- TOC entry 3193 (class 1259 OID 36060)
-- Name: gp_flaechen_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE gp_flaechen_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22475 (class 0 OID 0)
-- Dependencies: 3193
-- Name: gp_flaechen_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE gp_flaechen_prid_seq OWNED BY gp_flaechen.prid;


--
-- TOC entry 3196 (class 1259 OID 36070)
-- Name: gp_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE gp_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22476 (class 0 OID 0)
-- Dependencies: 3196
-- Name: gp_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE gp_prid_seq OWNED BY gp.prid;


--
-- TOC entry 3199 (class 1259 OID 36080)
-- Name: no_ko; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    name_identifikator character varying(255) NOT NULL,
    name_bezeichnung character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    typ integer,
    typ_txt character varying(255) NOT NULL,
    schutzinstrument_name character varying(255) NOT NULL,
    schutzinstrument_typ integer,
    schutzinstrument_typ_txt character varying(255) NOT NULL,
    id_denkmalpflege character varying(255),
    weitere_inventare character varying(255),
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    bemerkung character varying(255),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22477 (class 0 OID 0)
-- Dependencies: 3199
-- Name: TABLE no_ko; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO';


--
-- TOC entry 3200 (class 1259 OID 36086)
-- Name: no_ko_av; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_av (
    t_ili_tid character varying(200),
    oid character varying(30),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_no_ko_flaechen character varying,
    id_av character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22478 (class 0 OID 0)
-- Dependencies: 3200
-- Name: TABLE no_ko_av; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_av IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_AV';


--
-- TOC entry 3201 (class 1259 OID 36092)
-- Name: no_ko_av_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_av_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22479 (class 0 OID 0)
-- Dependencies: 3201
-- Name: no_ko_av_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_av_prid_seq OWNED BY no_ko_av.prid;


--
-- TOC entry 3204 (class 1259 OID 36102)
-- Name: no_ko_beschluesse; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_beschluesse (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_no_ko character varying,
    id_inkraftsetzung character varying,
    id_genehmigung character varying,
    id_erlass character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22480 (class 0 OID 0)
-- Dependencies: 3204
-- Name: TABLE no_ko_beschluesse; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_beschluesse IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_Beschluesse';


--
-- TOC entry 3205 (class 1259 OID 36108)
-- Name: no_ko_beschluesse_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_beschluesse_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22481 (class 0 OID 0)
-- Dependencies: 3205
-- Name: no_ko_beschluesse_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_beschluesse_prid_seq OWNED BY no_ko_beschluesse.prid;


--
-- TOC entry 3208 (class 1259 OID 36118)
-- Name: no_ko_flaechen; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_flaechen (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_no_ko character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22482 (class 0 OID 0)
-- Dependencies: 3208
-- Name: TABLE no_ko_flaechen; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_flaechen IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_Flaechen';


--
-- TOC entry 3209 (class 1259 OID 36124)
-- Name: no_ko_flaechen_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_flaechen_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22483 (class 0 OID 0)
-- Dependencies: 3209
-- Name: no_ko_flaechen_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_flaechen_prid_seq OWNED BY no_ko_flaechen.prid;


--
-- TOC entry 3212 (class 1259 OID 36134)
-- Name: no_ko_info; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_info (
    t_ili_tid character varying(200),
    kanton integer,
    kanton_txt character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    datenlieferant character varying(100) NOT NULL,
    erfassungsstand_no integer,
    erfassungsstand_no_txt character varying(255) NOT NULL,
    erfassungsstand_ko integer,
    erfassungsstand_ko_txt character varying(255) NOT NULL,
    nachfuehrungsstand_no date NOT NULL,
    nachfuehrungsstand_ko date NOT NULL,
    bemerkung character varying(255),
    oid character varying(30),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22484 (class 0 OID 0)
-- Dependencies: 3212
-- Name: TABLE no_ko_info; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_info IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_Info';


--
-- TOC entry 3213 (class 1259 OID 36140)
-- Name: no_ko_info_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_info_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22485 (class 0 OID 0)
-- Dependencies: 3213
-- Name: no_ko_info_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_info_prid_seq OWNED BY no_ko_info.prid;


--
-- TOC entry 3216 (class 1259 OID 36150)
-- Name: no_ko_linie; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_linie (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(CompoundCurve,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_no_ko character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22486 (class 0 OID 0)
-- Dependencies: 3216
-- Name: TABLE no_ko_linie; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_linie IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_Linie';


--
-- TOC entry 3217 (class 1259 OID 36156)
-- Name: no_ko_linie_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_linie_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22487 (class 0 OID 0)
-- Dependencies: 3217
-- Name: no_ko_linie_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_linie_prid_seq OWNED BY no_ko_linie.prid;


--
-- TOC entry 3220 (class 1259 OID 36166)
-- Name: no_ko_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22488 (class 0 OID 0)
-- Dependencies: 3220
-- Name: no_ko_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_prid_seq OWNED BY no_ko.prid;


--
-- TOC entry 3221 (class 1259 OID 36168)
-- Name: no_ko_punkte; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE no_ko_punkte (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    geometrie public.geometry(Point,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_no_ko character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22489 (class 0 OID 0)
-- Dependencies: 3221
-- Name: TABLE no_ko_punkte; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE no_ko_punkte IS '@iliname ORTSPLANUNG.Nutz_Plan.NO_KO_Punkte';


--
-- TOC entry 3222 (class 1259 OID 36174)
-- Name: no_ko_punkte_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE no_ko_punkte_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22490 (class 0 OID 0)
-- Dependencies: 3222
-- Name: no_ko_punkte_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE no_ko_punkte_prid_seq OWNED BY no_ko_punkte.prid;


--
-- TOC entry 3227 (class 1259 OID 36192)
-- Name: nz_info; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_info (
    t_ili_tid character varying(200),
    kanton integer,
    kanton_txt character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    datenlieferant character varying(100) NOT NULL,
    nachfuehrungsstand date NOT NULL,
    bemerkung character varying(255),
    oid character varying(30),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22491 (class 0 OID 0)
-- Dependencies: 3227
-- Name: TABLE nz_info; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_info IS '@iliname ORTSPLANUNG.Nutz_Plan.NZ_Info';


--
-- TOC entry 3228 (class 1259 OID 36198)
-- Name: nz_info_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_info_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22492 (class 0 OID 0)
-- Dependencies: 3228
-- Name: nz_info_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_info_prid_seq OWNED BY nz_info.prid;


--
-- TOC entry 3231 (class 1259 OID 36208)
-- Name: nz_kat_ueberlag_gmde; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_kat_ueberlag_gmde (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    zonenkuerzel_gemeinde character varying(20),
    zonenbezeichnung_gemeinde character varying(100) NOT NULL,
    id_zonenplan_gebiet character varying(10) NOT NULL,
    id_kat_ueberlag_kanton integer NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22493 (class 0 OID 0)
-- Dependencies: 3231
-- Name: TABLE nz_kat_ueberlag_gmde; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_kat_ueberlag_gmde IS '@iliname ORTSPLANUNG.Nutz_Plan.NZ_Kat_Ueberlag_Gmde';


--
-- TOC entry 3232 (class 1259 OID 36214)
-- Name: nz_kat_ueberlag_gmde_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_kat_ueberlag_gmde_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22494 (class 0 OID 0)
-- Dependencies: 3232
-- Name: nz_kat_ueberlag_gmde_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_kat_ueberlag_gmde_prid_seq OWNED BY nz_kat_ueberlag_gmde.prid;


--
-- TOC entry 3235 (class 1259 OID 36224)
-- Name: nz_kat_ueberlag_kanton; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_kat_ueberlag_kanton (
    t_id integer NOT NULL,
    t_ili_tid character varying(200),
    nummer integer NOT NULL,
    obergruppe character varying(100) NOT NULL,
    gruppe character varying(100) NOT NULL,
    bezeichnung character varying(100) NOT NULL,
    hauptnutzung_ch integer NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22495 (class 0 OID 0)
-- Dependencies: 3235
-- Name: TABLE nz_kat_ueberlag_kanton; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_kat_ueberlag_kanton IS '@iliname ORTSPLANUNG_KANT_ZONENKAT_TG01.UL_Kant_Zonenkat.Kantonale_ueberlagernde_Zonen';


--
-- TOC entry 3236 (class 1259 OID 36230)
-- Name: nz_kat_ueberlag_kanton_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_kat_ueberlag_kanton_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22496 (class 0 OID 0)
-- Dependencies: 3236
-- Name: nz_kat_ueberlag_kanton_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_kat_ueberlag_kanton_prid_seq OWNED BY nz_kat_ueberlag_kanton.prid;


--
-- TOC entry 3237 (class 1259 OID 36232)
-- Name: nz_ueberlag; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_ueberlag (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_art character varying,
    id_genehmigung character varying,
    id_inkraftsetzung character varying,
    id_erlass character varying,
    id_vorpruefung character varying,
    id_auflage character varying,
    id_abstimmung character varying,
    id_parlamentsbeschluss character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22497 (class 0 OID 0)
-- Dependencies: 3237
-- Name: TABLE nz_ueberlag; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_ueberlag IS '@iliname ORTSPLANUNG.Nutz_Plan.NZ_Ueberlag';


--
-- TOC entry 3238 (class 1259 OID 36238)
-- Name: nz_ueberlag_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_ueberlag_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22498 (class 0 OID 0)
-- Dependencies: 3238
-- Name: nz_ueberlag_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_ueberlag_prid_seq OWNED BY nz_ueberlag.prid;


--
-- TOC entry 3241 (class 1259 OID 36248)
-- Name: nz_zonen; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_zonen (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    geometrische_grundlage integer,
    geometrische_grundlage_txt character varying(255) NOT NULL,
    verfahren_haengig integer,
    verfahren_haengig_txt character varying(255) NOT NULL,
    es integer,
    es_txt character varying(255),
    aufgestuft integer,
    aufgestuft_txt character varying(255),
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    id_art character varying,
    id_genehmigung character varying,
    id_inkraftsetzung character varying,
    id_erlass character varying,
    id_vorpruefung character varying,
    id_auflage character varying,
    id_abstimmung character varying,
    id_parlamentsbeschluss character varying,
    prid integer NOT NULL
);


--
-- TOC entry 22499 (class 0 OID 0)
-- Dependencies: 3241
-- Name: TABLE nz_zonen; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_zonen IS '@iliname ORTSPLANUNG.Nutz_Plan.NZ_Zonen';


--
-- TOC entry 3242 (class 1259 OID 36254)
-- Name: nz_zonen_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_zonen_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22500 (class 0 OID 0)
-- Dependencies: 3242
-- Name: nz_zonen_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_zonen_prid_seq OWNED BY nz_zonen.prid;


--
-- TOC entry 3246 (class 1259 OID 36269)
-- Name: nz_zonenkat_gemeinde; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_zonenkat_gemeinde (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    zonenkuerzel_gemeinde character varying(20),
    zonenbezeichnung_gemeinde character varying(100) NOT NULL,
    id_zonenplan_gebiet character varying(10) NOT NULL,
    id_zonenkat_kanton integer NOT NULL,
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22501 (class 0 OID 0)
-- Dependencies: 3246
-- Name: TABLE nz_zonenkat_gemeinde; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_zonenkat_gemeinde IS '@iliname ORTSPLANUNG.Nutz_Plan.NZ_Zonenkat_Gemeinde';


--
-- TOC entry 3247 (class 1259 OID 36275)
-- Name: nz_zonenkat_gemeinde_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_zonenkat_gemeinde_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22502 (class 0 OID 0)
-- Dependencies: 3247
-- Name: nz_zonenkat_gemeinde_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_zonenkat_gemeinde_prid_seq OWNED BY nz_zonenkat_gemeinde.prid;


--
-- TOC entry 3250 (class 1259 OID 36285)
-- Name: nz_zonenkat_kanton; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE nz_zonenkat_kanton (
    t_id integer NOT NULL,
    t_ili_tid character varying(200),
    nummer integer NOT NULL,
    obergruppe character varying(100) NOT NULL,
    gruppe character varying(100) NOT NULL,
    bezeichnung character varying(100) NOT NULL,
    hauptnutzung_ch integer NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22503 (class 0 OID 0)
-- Dependencies: 3250
-- Name: TABLE nz_zonenkat_kanton; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE nz_zonenkat_kanton IS '@iliname ORTSPLANUNG_KANT_ZONENKAT_TG01.GN_Kant_Zonenkat.Kantonale_Grundnutzungszonen';


--
-- TOC entry 3251 (class 1259 OID 36291)
-- Name: nz_zonenkat_kanton_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE nz_zonenkat_kanton_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22504 (class 0 OID 0)
-- Dependencies: 3251
-- Name: nz_zonenkat_kanton_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE nz_zonenkat_kanton_prid_seq OWNED BY nz_zonenkat_kanton.prid;


--
-- TOC entry 3252 (class 1259 OID 36293)
-- Name: snp_info; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE snp_info (
    t_ili_tid character varying(200),
    kanton integer,
    kanton_txt character varying(255) NOT NULL,
    id_gebiet character varying(10) NOT NULL,
    datenlieferant character varying(100) NOT NULL,
    erfassungsstand_gp integer,
    erfassungsstand_gp_txt character varying(255) NOT NULL,
    erfassungsstand_blp integer,
    erfassungsstand_blp_txt character varying(255) NOT NULL,
    nachfuehrungsstand_gp date NOT NULL,
    nachfuehrungsstand_blp date NOT NULL,
    bemerkung character varying(255),
    oid character varying(30),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22505 (class 0 OID 0)
-- Dependencies: 3252
-- Name: TABLE snp_info; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE snp_info IS '@iliname ORTSPLANUNG.Nutz_Plan.SNP_Info';


--
-- TOC entry 3253 (class 1259 OID 36299)
-- Name: snp_info_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE snp_info_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22506 (class 0 OID 0)
-- Dependencies: 3253
-- Name: snp_info_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE snp_info_prid_seq OWNED BY snp_info.prid;


--
-- TOC entry 3278 (class 1259 OID 36382)
-- Name: vorpublikation; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE vorpublikation (
    t_ili_tid character varying(200),
    oid character varying(30) NOT NULL,
    datum date NOT NULL,
    typ integer,
    typ_txt character varying(255) NOT NULL,
    name character varying(255),
    geometrie public.geometry(CurvePolygon,2056),
    gueltig_von date,
    gueltig_bis date,
    t_id character varying NOT NULL,
    prid integer NOT NULL
);


--
-- TOC entry 22507 (class 0 OID 0)
-- Dependencies: 3278
-- Name: TABLE vorpublikation; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE vorpublikation IS '@iliname ORTSPLANUNG.Nutz_Plan.Vorpublikation';


--
-- TOC entry 3279 (class 1259 OID 36388)
-- Name: vorpublikation_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE vorpublikation_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22508 (class 0 OID 0)
-- Dependencies: 3279
-- Name: vorpublikation_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE vorpublikation_prid_seq OWNED BY vorpublikation.prid;


--
-- TOC entry 3282 (class 1259 OID 36398)
-- Name: zonenkat_info; Type: TABLE; Schema: oereb_ortsplanung; Owner: -
--

CREATE TABLE zonenkat_info (
    t_id integer NOT NULL,
    t_ili_tid character varying(200),
    version character varying(4) NOT NULL,
    datum date NOT NULL,
    bemerkung character varying(255),
    prid integer NOT NULL
);


--
-- TOC entry 22509 (class 0 OID 0)
-- Dependencies: 3282
-- Name: TABLE zonenkat_info; Type: COMMENT; Schema: oereb_ortsplanung; Owner: -
--

COMMENT ON TABLE zonenkat_info IS '@iliname ORTSPLANUNG_KANT_ZONENKAT_TG01.Kant_Zonenkat.Zonenkat_Info';


--
-- TOC entry 3283 (class 1259 OID 36401)
-- Name: zonenkat_info_prid_seq; Type: SEQUENCE; Schema: oereb_ortsplanung; Owner: -
--

CREATE SEQUENCE zonenkat_info_prid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 22510 (class 0 OID 0)
-- Dependencies: 3283
-- Name: zonenkat_info_prid_seq; Type: SEQUENCE OWNED BY; Schema: oereb_ortsplanung; Owner: -
--

ALTER SEQUENCE zonenkat_info_prid_seq OWNED BY zonenkat_info.prid;


--
-- TOC entry 22016 (class 2604 OID 44558)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb ALTER COLUMN prid SET DEFAULT nextval('awb_prid_seq'::regclass);


--
-- TOC entry 22017 (class 2604 OID 44559)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_info ALTER COLUMN prid SET DEFAULT nextval('awb_info_prid_seq'::regclass);


--
-- TOC entry 22018 (class 2604 OID 44561)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_linie ALTER COLUMN prid SET DEFAULT nextval('awb_linie_prid_seq'::regclass);


--
-- TOC entry 22019 (class 2604 OID 44563)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_punkte ALTER COLUMN prid SET DEFAULT nextval('awb_punkte_prid_seq'::regclass);


--
-- TOC entry 22020 (class 2604 OID 44566)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY beschluesse ALTER COLUMN prid SET DEFAULT nextval('beschluesse_prid_seq'::regclass);


--
-- TOC entry 22021 (class 2604 OID 44568)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp ALTER COLUMN prid SET DEFAULT nextval('blp_prid_seq'::regclass);


--
-- TOC entry 22022 (class 2604 OID 44569)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_flaechen ALTER COLUMN prid SET DEFAULT nextval('blp_flaechen_prid_seq'::regclass);


--
-- TOC entry 22023 (class 2604 OID 44570)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_flaechen_beschluesse ALTER COLUMN prid SET DEFAULT nextval('blp_flaechen_beschluesse_prid_seq'::regclass);


--
-- TOC entry 22024 (class 2604 OID 44573)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_linie ALTER COLUMN prid SET DEFAULT nextval('blp_linie_prid_seq'::regclass);


--
-- TOC entry 22025 (class 2604 OID 44576)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gemeinde_tg ALTER COLUMN prid SET DEFAULT nextval('gemeinde_tg_prid_seq'::regclass);


--
-- TOC entry 22026 (class 2604 OID 44577)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp ALTER COLUMN prid SET DEFAULT nextval('gp_prid_seq'::regclass);


--
-- TOC entry 22027 (class 2604 OID 44578)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp_beschluesse ALTER COLUMN prid SET DEFAULT nextval('gp_beschluesse_prid_seq'::regclass);


--
-- TOC entry 22028 (class 2604 OID 44580)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp_flaechen ALTER COLUMN prid SET DEFAULT nextval('gp_flaechen_prid_seq'::regclass);


--
-- TOC entry 22029 (class 2604 OID 44583)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko ALTER COLUMN prid SET DEFAULT nextval('no_ko_prid_seq'::regclass);


--
-- TOC entry 22030 (class 2604 OID 44584)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_av ALTER COLUMN prid SET DEFAULT nextval('no_ko_av_prid_seq'::regclass);


--
-- TOC entry 22031 (class 2604 OID 44586)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_beschluesse ALTER COLUMN prid SET DEFAULT nextval('no_ko_beschluesse_prid_seq'::regclass);


--
-- TOC entry 22032 (class 2604 OID 44588)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_flaechen ALTER COLUMN prid SET DEFAULT nextval('no_ko_flaechen_prid_seq'::regclass);


--
-- TOC entry 22033 (class 2604 OID 44590)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_info ALTER COLUMN prid SET DEFAULT nextval('no_ko_info_prid_seq'::regclass);


--
-- TOC entry 22034 (class 2604 OID 44592)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_linie ALTER COLUMN prid SET DEFAULT nextval('no_ko_linie_prid_seq'::regclass);


--
-- TOC entry 22035 (class 2604 OID 44594)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_punkte ALTER COLUMN prid SET DEFAULT nextval('no_ko_punkte_prid_seq'::regclass);


--
-- TOC entry 22036 (class 2604 OID 44597)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_info ALTER COLUMN prid SET DEFAULT nextval('nz_info_prid_seq'::regclass);


--
-- TOC entry 22037 (class 2604 OID 44599)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_kat_ueberlag_gmde ALTER COLUMN prid SET DEFAULT nextval('nz_kat_ueberlag_gmde_prid_seq'::regclass);


--
-- TOC entry 22038 (class 2604 OID 44601)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_kat_ueberlag_kanton ALTER COLUMN prid SET DEFAULT nextval('nz_kat_ueberlag_kanton_prid_seq'::regclass);


--
-- TOC entry 22039 (class 2604 OID 44602)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_ueberlag ALTER COLUMN prid SET DEFAULT nextval('nz_ueberlag_prid_seq'::regclass);


--
-- TOC entry 22040 (class 2604 OID 44604)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonen ALTER COLUMN prid SET DEFAULT nextval('nz_zonen_prid_seq'::regclass);


--
-- TOC entry 22041 (class 2604 OID 44606)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonenkat_gemeinde ALTER COLUMN prid SET DEFAULT nextval('nz_zonenkat_gemeinde_prid_seq'::regclass);


--
-- TOC entry 22042 (class 2604 OID 44608)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonenkat_kanton ALTER COLUMN prid SET DEFAULT nextval('nz_zonenkat_kanton_prid_seq'::regclass);


--
-- TOC entry 22043 (class 2604 OID 44609)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY snp_info ALTER COLUMN prid SET DEFAULT nextval('snp_info_prid_seq'::regclass);


--
-- TOC entry 22044 (class 2604 OID 44622)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY vorpublikation ALTER COLUMN prid SET DEFAULT nextval('vorpublikation_prid_seq'::regclass);


--
-- TOC entry 22045 (class 2604 OID 44624)
-- Name: prid; Type: DEFAULT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY zonenkat_info ALTER COLUMN prid SET DEFAULT nextval('zonenkat_info_prid_seq'::regclass);


--
-- TOC entry 22049 (class 2606 OID 1447034)
-- Name: awb_info_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_info
    ADD CONSTRAINT awb_info_prid PRIMARY KEY (prid);


--
-- TOC entry 22052 (class 2606 OID 1447038)
-- Name: awb_linie_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_linie
    ADD CONSTRAINT awb_linie_prid PRIMARY KEY (prid);


--
-- TOC entry 22047 (class 2606 OID 1447042)
-- Name: awb_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb
    ADD CONSTRAINT awb_prid PRIMARY KEY (prid);


--
-- TOC entry 22055 (class 2606 OID 1447044)
-- Name: awb_punkte_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY awb_punkte
    ADD CONSTRAINT awb_punkte_prid PRIMARY KEY (prid);


--
-- TOC entry 22057 (class 2606 OID 1447050)
-- Name: beschluesse_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY beschluesse
    ADD CONSTRAINT beschluesse_prid PRIMARY KEY (prid);


--
-- TOC entry 22064 (class 2606 OID 1447054)
-- Name: blp_flaechen_beschluesse_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_flaechen_beschluesse
    ADD CONSTRAINT blp_flaechen_beschluesse_prid PRIMARY KEY (prid);


--
-- TOC entry 22062 (class 2606 OID 1447058)
-- Name: blp_flaechen_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_flaechen
    ADD CONSTRAINT blp_flaechen_prid PRIMARY KEY (prid);


--
-- TOC entry 22067 (class 2606 OID 1447062)
-- Name: blp_linie_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp_linie
    ADD CONSTRAINT blp_linie_prid PRIMARY KEY (prid);


--
-- TOC entry 22059 (class 2606 OID 1447066)
-- Name: blp_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY blp
    ADD CONSTRAINT blp_prid PRIMARY KEY (prid);


--
-- TOC entry 22069 (class 2606 OID 1447070)
-- Name: gemeinde_tg_pkey; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gemeinde_tg
    ADD CONSTRAINT gemeinde_tg_pkey PRIMARY KEY (t_id);


--
-- TOC entry 22073 (class 2606 OID 1447072)
-- Name: gp_beschluesse_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp_beschluesse
    ADD CONSTRAINT gp_beschluesse_prid PRIMARY KEY (prid);


--
-- TOC entry 22076 (class 2606 OID 1447076)
-- Name: gp_flaechen_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp_flaechen
    ADD CONSTRAINT gp_flaechen_prid PRIMARY KEY (prid);


--
-- TOC entry 22071 (class 2606 OID 1447080)
-- Name: gp_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY gp
    ADD CONSTRAINT gp_prid PRIMARY KEY (prid);


--
-- TOC entry 22109 (class 2606 OID 1447084)
-- Name: kantonale_grundnutzungszonen_pkey; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonenkat_kanton
    ADD CONSTRAINT kantonale_grundnutzungszonen_pkey PRIMARY KEY (t_id);


--
-- TOC entry 22099 (class 2606 OID 1447086)
-- Name: kantonale_ueberlagernde_zonen_pkey; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_kat_ueberlag_kanton
    ADD CONSTRAINT kantonale_ueberlagernde_zonen_pkey PRIMARY KEY (t_id);


--
-- TOC entry 22080 (class 2606 OID 1447088)
-- Name: no_ko_av_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_av
    ADD CONSTRAINT no_ko_av_prid PRIMARY KEY (prid);


--
-- TOC entry 22082 (class 2606 OID 1447092)
-- Name: no_ko_beschluesse_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_beschluesse
    ADD CONSTRAINT no_ko_beschluesse_prid PRIMARY KEY (prid);


--
-- TOC entry 22085 (class 2606 OID 1447096)
-- Name: no_ko_flaechen_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_flaechen
    ADD CONSTRAINT no_ko_flaechen_prid PRIMARY KEY (prid);


--
-- TOC entry 22087 (class 2606 OID 1447100)
-- Name: no_ko_info_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_info
    ADD CONSTRAINT no_ko_info_prid PRIMARY KEY (prid);


--
-- TOC entry 22090 (class 2606 OID 1447104)
-- Name: no_ko_linie_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_linie
    ADD CONSTRAINT no_ko_linie_prid PRIMARY KEY (prid);


--
-- TOC entry 22078 (class 2606 OID 1447108)
-- Name: no_ko_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko
    ADD CONSTRAINT no_ko_prid PRIMARY KEY (prid);


--
-- TOC entry 22093 (class 2606 OID 1447110)
-- Name: no_ko_punkte_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY no_ko_punkte
    ADD CONSTRAINT no_ko_punkte_prid PRIMARY KEY (prid);


--
-- TOC entry 22095 (class 2606 OID 1447116)
-- Name: nz_info_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_info
    ADD CONSTRAINT nz_info_prid PRIMARY KEY (prid);


--
-- TOC entry 22097 (class 2606 OID 1447120)
-- Name: nz_kat_ueberlag_gmde_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_kat_ueberlag_gmde
    ADD CONSTRAINT nz_kat_ueberlag_gmde_prid PRIMARY KEY (prid);


--
-- TOC entry 22102 (class 2606 OID 1447124)
-- Name: nz_ueberlag_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_ueberlag
    ADD CONSTRAINT nz_ueberlag_prid PRIMARY KEY (prid);


--
-- TOC entry 22105 (class 2606 OID 1447128)
-- Name: nz_zonen_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonen
    ADD CONSTRAINT nz_zonen_prid PRIMARY KEY (prid);


--
-- TOC entry 22107 (class 2606 OID 1447132)
-- Name: nz_zonenkat_gemeinde_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY nz_zonenkat_gemeinde
    ADD CONSTRAINT nz_zonenkat_gemeinde_prid PRIMARY KEY (prid);


--
-- TOC entry 22111 (class 2606 OID 1447136)
-- Name: snp_info_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY snp_info
    ADD CONSTRAINT snp_info_prid PRIMARY KEY (prid);


--
-- TOC entry 22113 (class 2606 OID 1447162)
-- Name: vorpublikation_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY vorpublikation
    ADD CONSTRAINT vorpublikation_prid PRIMARY KEY (prid);


--
-- TOC entry 22115 (class 2606 OID 1447166)
-- Name: zonenkat_info_prid; Type: CONSTRAINT; Schema: oereb_ortsplanung; Owner: -
--

ALTER TABLE ONLY zonenkat_info
    ADD CONSTRAINT zonenkat_info_prid PRIMARY KEY (prid);


--
-- TOC entry 22050 (class 1259 OID 1450285)
-- Name: awb_linie_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX awb_linie_geometrie ON awb_linie USING gist (geometrie);


--
-- TOC entry 22053 (class 1259 OID 1450287)
-- Name: awb_punkte_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX awb_punkte_geometrie ON awb_punkte USING gist (geometrie);


--
-- TOC entry 22060 (class 1259 OID 1450289)
-- Name: blp_flaechen_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX blp_flaechen_geometrie ON blp_flaechen USING gist (geometrie);


--
-- TOC entry 22065 (class 1259 OID 1450291)
-- Name: blp_linie_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX blp_linie_geometrie ON blp_linie USING gist (geometrie);


--
-- TOC entry 22074 (class 1259 OID 1450293)
-- Name: gp_flaechen_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX gp_flaechen_geometrie ON gp_flaechen USING gist (geometrie);


--
-- TOC entry 22083 (class 1259 OID 1450295)
-- Name: no_ko_flaechen_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX no_ko_flaechen_geometrie ON no_ko_flaechen USING gist (geometrie);


--
-- TOC entry 22088 (class 1259 OID 1450297)
-- Name: no_ko_linie_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX no_ko_linie_geometrie ON no_ko_linie USING gist (geometrie);


--
-- TOC entry 22091 (class 1259 OID 1450298)
-- Name: no_ko_punkte_geometrie; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX no_ko_punkte_geometrie ON no_ko_punkte USING gist (geometrie);


--
-- TOC entry 22100 (class 1259 OID 1450301)
-- Name: nz_ueberlag_gist; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX nz_ueberlag_gist ON nz_ueberlag USING gist (geometrie);


--
-- TOC entry 22103 (class 1259 OID 1450303)
-- Name: nz_zonen_gist; Type: INDEX; Schema: oereb_ortsplanung; Owner: -
--

CREATE INDEX nz_zonen_gist ON nz_zonen USING gist (geometrie);


-- Completed on 2017-03-15 11:45:08 CET

--
-- PostgreSQL database dump complete
--

